///////////////////////////////////////////////////////////
// Company         : Micro Digital                       //
// Address         : Office # C7 Raza Plaza              //
//                   DAV College Road                    //
//                   Rawalpindi,                         //
//                   Pakistan.                           //
// Programmed By   : Rashid Mehmood                      //
// Project Name    : 8051 Digital Clock On 16x2 LCD      //
// Crystal         : 24.000000 MHz                       //
// Microcontroller : AT89C51-C52-C55-S51-S52             //
///////////////////////////////////////////////////////////

#include <AT89X51.H>
#include <stdio.h>
#include "lcd4bit.h"

// Used in getkeyex function
// to take action after regular
// number of times a key is found
// pressed.
#define MaxCtr 10

// Maximum buttons to be scanned.
#define MaxBtns 2

// Keys definition.
#define SEC_KEY 		0X0001
#define MIN_KEY 		0X0002
#define MIN_KEY_HOLD 	0X0200
#define HOUR_KEY 		0X0004
#define HOUR_KEY_HOLD 	0X0400

#include "Port.h"
#include "Timer0.h"

// This function initializes
// sytem.
void InitSystem()
{
	// Initialize 16x2 LCD.
	init_lcd();
	
	// Initialize Timer0 for clock.
	InitTimer0();

	// Print titiles information.
	print_lcd("   8051  Clock   \0");
	gotoxy_lcd(1, 2);
	print_lcd("Time : \0");
}

void main()
{
	short PrevSec = -1;
	struct Time time;
	char sTime[10];

	// Flag to note that
	// time is changed by
	// user.
	short bChanged = 0;
	InitSystem();
	while(1)
	{
		// Get current system time.
		GetTime(&time);

		// If time changed then update it
		// on display.
		if(time.Sec != PrevSec || bChanged)
		{
			PrevSec = time.Sec;
			sprintf(sTime, "%02d:%02d:%02d", (int) time.Hour, (int) time.Min, (int) time.Sec);
			gotoxy_lcd(8, 2);
			print_lcd(sTime);
		}

		// Reset changed flag.
		bChanged = 0;
		switch(getkeyex(P1))
		{
			// If Seconds button pressed.
			case SEC_KEY:
				SetSecond(0);
				break;
			// If Minutes button pressed or hold.
			case MIN_KEY:
			case MIN_KEY_HOLD:
				time.Min ++;
				if(time.Min > 59)
					time.Min = 0;
				SetMinute(time.Min);
				bChanged = 1;
				break;

			// If Hours button pressed or hold.
			case HOUR_KEY:
			case HOUR_KEY_HOLD:
				time.Hour ++;
				if(time.Hour > 23)
					time.Hour = 0;
				SetHour(time.Hour);
				bChanged = 1;
				break;
		}
	}
}

